' create station ticks automatically
' written by Melissa Shaw
' requested by Signs - Traffic

Sub Main

'Sub locate_selectElementsToModify
Dim elem as New MbeElement
Dim filePos as Long
Dim point as MbePoint
Dim acceptPoint as MbePoint
Dim acceptScreenPt as MbePoint
Dim firstScreenPt as MbePoint
Dim stat as Integer
Dim view as Integer
Dim acceptView as Integer
Dim continueLocate as Integer
Dim haveAcceptPoint as Integer
continueLocate = FALSE
haveAcceptPoint = FALSE

'   Do
' Display messages
'     Call locate_displayPrompts()
' Start locating an element, don't put out msgs,
' don't hilite when found, don't allow components,
' continue locate from previous element if appropriate.
     MbeStartLocate 0, 0, 0, continueLocate
' If accepted element or continuing from a reset
' send the previously entered point.
     If haveAcceptPoint Or continueLocate Then
     Call MbeSendDataPoint(acceptPoint, acceptView)
     continueLocate = FALSE
     MbeState.noElementDisplay = 0   
     
' If previous element accepted, future comparisons are to
' accept point
     If haveAcceptPoint Then
     haveAcceptPoint = FALSE
     point = acceptPoint
     view = acceptView
     firstScreenPt = acceptScreenPt
    End If
  Else

' Wait for a data point or a reset
     MbeWritePrompt "Place Station ticks > Location for First Even Station or reset to end"
     
     MbeGetInput MBE_DataPointInput, MBE_ResetInput
' If user resets, exit the loop.
     If MbeState.inputType = MBE_ResetInput Then
     Exit Do
' On a data point, retrieve the point for future use, then
' send it through to be processed.
     ElseIf MbeState.inputType = MBE_DataPointInput Then
     stat=MbeState.getInputDataPoint(point, view, firstScreenPt)
     MbeSendLastInput
    End If
   End If
' If we found an element, check for acceptability
     If MbeState.cmdResult = MBE_AcceptQuery Then
' if we did not find a line, keep resetting until
' either we find one or we run out of candidates
  Do
     filePos = elem.fromLocate()
'     If locate_isElementAcceptable(elem) Then
' located an acceptable element - hilite it
     elem.display MBE_Hilite
' prompt the user to accept or reject it
     MbeWritePrompt "Accept / Reject"
' get data to accept, reset to reject
     MbeGetInput MBE_DataPointInput, MBE_ResetInput
     If MbeState.inputType = MBE_DataPointInput Then
' on Data pnt, accept element and modify it
     stat = MbeState.getInputDataPoint( _
     acceptPoint, acceptView, acceptScreenPt)
     Call locate_manipulateElement(point, view)
' continue locating if accept
' point near first point
'     continueLocate = locate_pointsCloseEnough( _acceptScreenPt, firstScreenPt)
     haveAcceptPoint = TRUE
    Else
' user rejected it - continue looking around
' the same point by continuing the locate
' operation in the loop.
     elem.display MBE_NormalDraw
     acceptPoint = point
     acceptView = view
     continueLocate = TRUE
    End If
   Exit Do
'  Else
' found element but its not acceptable
' to our filter.
' Send resets to the locate logic to cause it to
' retrieve the next closest element in range
     MbeSendReset
     If MbeState.cmdResult = MBE_ElementNotFound Then
     Call locate_elementUnacceptable
    Exit Do
   End If
' End If
 Loop While elem.type <> MBE_Line
 ElseIf MbeState.cmdResult = MBE_ElementNotFound Then
 MbeWriteError "Element Not Found"
  Else
     print "unexpected MbeState.cmdResult of "; MbeState.cmdResult
    End If
'   Loop
  End Sub
'---------------------------------------------------------------
'locate_pointsCloseEnough - returns TRUE if points roughly
'within the locate tolerance, FALSE otherwise
'---------------------------------------------------------------
    Function locate_pointsCloseEnough(point1 as MbePoint, point2 as MbePoint) as Integer
    If Abs (point1.x - point2.x) + Abs (point1.y - point2.y) _
    < MbeState.LocateTolerance Then
    locate_pointsCloseEnough = TRUE
   End If
  End Function
'---------------------------------------------------------------
' locate_manipulateElement - performs the actual manipulation
' on the selected element. This manipulation sequences commands
' and uses the MbeRelocate subroutine to make the command work
' on the previously selected element
'---------------------------------------------------------------
     Sub locate_manipulateElement(point as MbePoint, view as Integer)
     Dim elem as New MbeElement
     Dim filePos as Long
     Dim spacing$ as string
     Dim unitName as string
     Dim oldScale as MbePoint
     Dim OldAngle as Double
     oldAngle = MbeSettings.angle
     unitName = MbeDgnInfo.masterUnitName
 stat = MbeSettings.getScale(oldScale)
 MbeSettings.angle = 0
     If unitName = "'" then MbeSendCommand "ACTIVE SCALE 2.0000"
     
'     Display messages
      spacing = MbeInputBox ("Enter the Station spacing:", "100", "Station spacing")
     space_no# = Val(spacing$)
' start command place icon along
    MbeSendCommand "ATTACH LIBRARY x:\WRKSPC_INDOT_XM\Workspace\Standards\cell\patterns.cel"
    MbeSetAppVariable "", "tcb->activeCell", "TICK"
    MbeSendKeyin "MDl Load CELLTOOL"
    MbeSendCommand "PLACE CELL ALONG "

    MbeSetAppVariable "CELLTOOL", "tcb->activecell", "TICK"
    MbeSetScaledAppVar "CELLTOOL", "toolParameters.spacingDistance", space_no#
    MbeRelocate point, view
    MbeSendDataPoint point, view
    
'     The first point is the user's point
     filepos = elem.fromLocate()
'     elem.display MBE_NormalDraw
'        MbeSendDataPoint point, view
         MbeSendCommand "ACTIVE SCALE (oldScale)"
         MbeSettings.angle = oldAngle

  stat = MbeSettings.setScale(oldScale)
'     MbeSendCommand "NULL"
'     MbeState.noElementDisplay = 1
    MbeSendCommand "UPDATE VIEW EXTENDED 1"
End Sub
 
 
 
 