Sub main
Dim startPoint As MbePoint
Dim point As MbePoint, point2 As MbePoint

'   Level Variable Definitions
BaseLevels$ = "S_RDWY_Curb-back,S_DR_Edge of gutter line,S_RDWY_Curb-bottom,S_RDWY_Curb-top,S_TOPO_Edge of Conc,S_RDWY_Edge of gravel,S_RDWY_Pavement-edge,S_RDWY_Road crown,S_TOPO_Railroad,S_PROP_Turn apron,S_RDWY_Drive-private,S_RDWY_Drive-commercial,S_RDWY_Drive-field,S_PROP_Sidewalk"
Utility$ = "S_UTIL_Ug-Elec,S_UTIL_Ug-sanitary sewer,S_UTIL_Ug-storm san sewer,S_UTIL_Ug-gas,S_UTIL_Ug-petroleum,S_UTIL_Ug-Tel,S_UTIL_Ug-cable TV,S_UTIL_Ug-water,S_UTIL_Manhole-cable TV,S_UTIL_Manhole-drainage,S_UTIL_Manhole-Elec,S_UTIL_Manhole-gas,S_UTIL_Manhole-traffic Sig,S_UTIL_Manhole-other,S_UTIL_Manhole-sewer,S_UTIL_Manhole-Tel,S_UTIL_Manhole-water"
Drainage$ = "S_DR_Drainage pipe,S_UTIL_Ug-storm sewer,S_DR_Conc paved side ditch,S_DR_Waters edge,S_DR_Ditch line,S_DR_Water flow line,S_DR_Inlet-drop,S_UTIL_Manhole-drainage"
Building$ = "S_PROP_Bldg,S_PROP_Bldg-Overhang,S_PROP_Canopy Cor,S_PROP_Outline of Porch or Deck,S_PROP_Steps"

'   Data Point Definitions
startPoint.x = 0#
startPoint.y = 0#
startPoint.z = 0#
point.x = startPoint.x
point.y = startPoint.y
point.z = startPoint.z

'   DGN Display State
Dim DGNState As Integer
DGNState = 0

'   Selection Display State
Dim SelState As Integer
Dim DrainState As Integer
DrainState = 0
Dim UtilState As Integer
UtilState = 0
Dim BuildState As Integer
BuildState = 0
Dim DrainOvrState As Integer
DrainOvrState = 0
    
'Reactivate the dialog unless canceled
Do
    '   Open the Dialog Box and run appropriate Sub
    actionButton = mbeOpenModalDialog (1)
    If actionButton = 1001 Then
        GoSub DispReset
    ElseIf actionButton = 1002 Then
        DispLev$ = Utility
        SelState = UtilState
        GoSub VisualDisp
        UtilState = SelState
    ElseIf actionButton = 1003 Then
        DispLev$ = Drainage
        SelState = DrainState
        DrainOvrState = 0
        GoSub VisualDisp
        GoSub DrainOver
        DrainOvrState = 1        
        DrainState = SelState
    ElseIf actionButton = 1004 Then
        DispLev$ = Building
        SelState = BuildState
        GoSub VisualDisp
        BuildState = SelState
    End If
        
    '   Reset Symbology
    MbeSendKeyin "ACTIVE LEVEL Default"
    MbeSendKeyin "ACTIVE SYMBOLOGY ByLevel"
Loop While actionButton <> 4

Exit Sub

    '   Resets the display to the default state (all elements on and bylevel)
    DispReset:
        MbeSendCommand "MDL SILENTLOAD SELECTBY"
        MbeSendCommand "SELECTBY LEVEL " & BaseLevels
        MbeSendCommand "SELECTBY EXECUTE"
        
        MbeSendKeyin "ACTIVE COLOR BYLEVEL"
        MbeSendKeyin "CHANGE COLOR ELEMENT" 
        MbeSendKeyin "CHOOSE NONE"
        MbeSendCommand "MDL UNLOAD SELECTBY"
        
        MbeSendKeyin "SET LEVELS ON *"
        MbeSendDataPoint point, 1%
        MbeSendReset
        If DrainOvrState = 1 Then
            GoSub DrainOver
        End If
        
        DGNState = 0
        SelState = 0
        DrainState = 0
        UtilState = 0
        BuildState = 0
        
        
    Return

    '   Sets Base Levels to color 176, and turns them and the selected level set on
    VisualDisp:
        
        If DGNState = 0 Then
            MbeSendKeyin "ACTIVE LEVEL Default"

            MbeSendKeyin "SET LEVELS OFF *"
            MbeSendDataPoint point, 1%
            MbeSendReset    

            MbeSendCommand "MDL SILENTLOAD SELECTBY"
            MbeSendCommand "SELECTBY LEVEL " & BaseLevels
            MbeSendCommand "SELECTBY EXECUTE"

            MbeSendKeyin "ACTIVE COLOR 176"
            MbeSendKeyin "CHANGE COLOR ELEMENT" 
            MbeSendKeyin "CHOOSE NONE"
            MbeSendCommand "MDL UNLOAD SELECTBY"
            MbeSendKeyin "ACTIVE LEVEL Default"
            MbeSendKeyin "SET LEVELS ON " & BaseLevels
            MbeSendDataPoint point, 1%
            MbeSendReset

            DGNState = 1

        ElseIf DGNState = 1 Then
            MbeSendKeyin "ACTIVE LEVEL Default"
            MbeSendKeyin "SET LEVELS ON " & BaseLevels
            MbeSendDataPoint point, 1%
            MbeSendReset
            DGNState = 2
        End If
        
        If SelState = 0 Then
            MbeSendKeyin "SET LEVELS ON " & DispLev
            MbeSendDataPoint point, 1%
            MbeSendReset
            SelState = 1
        ElseIf SelState = 1 Then
            MbeSendKeyin "SET LEVELS OFF " & DispLev
            MbeSendDataPoint point, 1%
            MbeSendReset
            SelState = 0
        End If
        
    Return

    '   Defines Drainage Level Overrides
    DrainOver:
        If DrainOvrState = 0 Then
            MbeSendCommand "MDL SILENTLOAD SELECTBY"
            MbeSendCommand "SELECTBY LEVEL S_DR_Drainage pipe"
            MbeSendCommand "SELECTBY EXECUTE"
            
            MbeSendKeyin "ACTIVE COLOR 3"
            MbeSendKeyin "CHANGE COLOR ELEMENT" 
            MbeSendKeyin "CHOOSE NONE"
            MbeSendCommand "MDL UNLOAD SELECTBY"
            DrainOvrState = 1
            
        ElseIf DrainOvrState = 1 Then
            MbeSendCommand "MDL SILENTLOAD SELECTBY"
            MbeSendCommand "SELECTBY LEVEL S_DR_Drainage pipe"
            MbeSendCommand "SELECTBY EXECUTE"
            
            MbeSendKeyin "ACTIVE COLOR 1"
            MbeSendKeyin "CHANGE COLOR ELEMENT" 
            MbeSendKeyin "CHOOSE NONE"
            MbeSendCommand "MDL UNLOAD SELECTBY"
            DrainOvrState = 0
        End If    
   Return
End Sub
 