; Script M_INDEX.SC

;This script allows the user to copy the M_INDEX table to a new name,
;then mark desired records and print a report of the marked records.

;This script was written by S.J.Hull 2-5340 for Asfahan Khan 3-2273 02/06/96

;It requires that tables M_INDEX.DB and M_TABLE.DB, report M_INDEX.R1 and
;script M_INDEX.SC all exist and in the same subdirectory for execution.


PROC M_INDEX()
SHOWPULLDOWN ENDMENU
WHILE (True)
  SHOWPOPUP "Metric Standards Index" @8,27
    "Create"  :  "Create a new index file"                   : "NewIndex",
    "Select"  :  "Select an index to view"                   : "RevIndex",
    "Delete"  :  "Delete an index file"                      : "DelIndex",
    "Rename"  :  "Rename an index and/or change description" : "ChgIndex",
    "Quit"    :  "Quit program and exit"                     : "Quit"
  ENDMENU
  TO Choice
  SWITCH
    CASE Choice="NewIndex"  :  New_index()
    CASE Choice="RevIndex"  :  Rev_index()
    CASE Choice="DelIndex"  :  Del_index()
    CASE Choice="ChgIndex"  :  Chg_index()
    CASE Choice="Quit"    :  Return
    OTHERWISE             :  beep loop
  ENDSWITCH
ENDWHILE
ENDPROC

PROC REV_INDEX()
  if istable("m_table")=false
  then 
    message "Problems - cannot find index to tables"
    beep sleep 3000 message "" return
  endif
  if isempty("m_table")=true
  then
    message "Problems - there are no tables to select"
    beep sleep 3000 message "" return
  endif 
  TblList("View")
  if retval=false
  then clear return
  endif
  tbldesc=Txt[tblname]
  if istable(tblname)=false
  then 
    message "Problems - cannot find "+tblname+" Index Table"
    beep sleep 3000 message "" return
  endif  
  view tblname
  while(true)
  moveto [code meaning] moveto [mark]
  message txt[tblname]
  wait table 
  prompt 
    "[Esc]=Exit   [F6]=Mark Item   [Alt][F6]=Mark All   [Alt][F7]=Print Report"
  until "F6","F36","Enter","Esc","F37"
  ans = retval
  if ans="Esc"
  then clear clearimage return
  endif
  if ans="Enter"
  then down loop
  endif
  if ans="F6"
  then 
    editkey
    if [mark]=""
    then [mark]="\251"
    else [mark]=""
    endif
    moveto [mark]
    do_it! down
    loop
  endif   
  if ans="F36"
  then
    editkey
    if mark="" 
    then mark="\251"
    else mark=""
    endif
    scan
    [mark]=mark
    endscan
    home
    do_it!      
  endif  
  if ans="F37"
  then
    {Ask} typein tblname keypress "Enter" Check 
    moveto [mark] typein "not blank" do_it!
    if isempty("answer")=true
    then
      message "No marked items to report" sleep 3000
    else
      message "Preparing report"
      copyreport "m_index" "1" "answer" "r"
      output("answer","r","")
      message ""
    endif
    clearimage moveto 1 clearimage clear
  endif
  endwhile
ENDPROC

PROC DEL_INDEX()
  if istable("m_table")=false
  then 
    message "Problems - cannot find index to tables"
    beep sleep 3000 message "" return
  endif
  if isempty("m_table")=true
  then
    message "Problems - there are no tables to select"
    beep sleep 3000 message "" return
  endif 

  TblList("Delete")
  if retval=false
  then clear return
  endif

  SHOWDIALOG "WARNING - Confirm Delete"
    @7,16 height 10 width 50
    @1,4 ?? "Permanently delete this metric index ??"
  Frame from 2,1 to 4,46
    @3,2 ?? TblName+" : "+Txt[TblName]
  Pushbutton @6,10 width 10 "Cancel" CANCEL value "" TAG ""
    to Retval
  Pushbutton @6,26 width 10 "OK" OK value "" TAG ""
    to Retval
  ENDDIALOG

  if retval=false
  then 
    message "Canceling 'Delete'" sleep 1500 message ""
    clear return
  else
    if istable(tblname)
    then delete tblname
    endif
    view "m_table" 
    moveto [table]
    locate tblname
    if retval=true
    then editkey del do_it!
    endif
    clear reset message tblname+" has been deleted"
    sleep 1500 message ""
  endif
  clear reset
ENDPROC

PROC CHG_INDEX()
  if istable("m_table")=false
  then 
    message "Problems - cannot find index to tables"
    beep sleep 3000 message "" return
  endif
  if isempty("m_table")=true
  then
    message "Problems - there are no tables to select"
    beep sleep 3000 message "" return
  endif 

  TblList("Rename")
  if retval=false
  then clear return
  endif
  OldTbl=TblName
  OldDesc=Txt[TblName]
  TblName=OldName
  TblDesc=OldDesc
  WHILE(TRUE)
  SHOWDIALOG "Change Index Name and/or Description"
    @8,15 Height 11 Width 54
    @1,1 ?? "   Old Name:  "+OldTbl
    @2,1 ?? "   New Name: "+TblName
    Accept @2,14 Width 11 "A8" Required Picture "*!"
      TAG "NewName" To TblName
    @4,1 ?? "   Old Desc:  "+OldDesc
    @5,1 ?? "   New Desc: "+TblDesc
    Accept @5,14 Width 37 "A34" Required Picture "*@"
      TAG "NewDesc" to TblDesc
    Pushbutton @7,11 width 10 "OK" OK default value "" TAG ""
      to Retval
    Pushbutton @7,30 width 10 "Cancel" CANCEL value "" TAG ""
      to Retval
  ENDDIALOG
  if retval=false
  then clear return
  endif
  if tblname="" or tbldesc=""
  then message "Name and Description cannot be blank" loop
  endif
  if istable(tblname) and tblname<>oldtbl
  then message tblname+" already exists - use a different name"
  loop
  endif
  errorproc="FileError"
  if tblname<>oldtbl
  then rename oldtbl tblname
  endif
  if istable(tblname)=false
  then message ErrorTxt beep
  release vars errorproc 
  loop
  endif
  view "m_table"
  editkey
  moveto [table]
  locate(oldtbl)
  if retval=false
  then end down
  endif
  [table]=tblname
  [description]=tbldesc
  do_it! clear clearimage reset
  message "Name and/or description have been revised"
  quitloop clear
  ENDWHILE

ENDPROC

PROC TblList(msg)
  DYNARRAY Txt[]
  MESSAGE "Loading current Index list ..."
  VIEW "M_Table"
  SCAN          
    Txt[[Table]] = [Description]
  ENDSCAN         
  CLEARIMAGE      
  MESSAGE "Select an Index to "+msg

  SHOWDIALOG "Select an Index to "+msg
    @3,18  HEIGHT 18  WIDTH 43

    FRAME FROM 10,1 TO 12,38
      @10,3 ?? "Description: "
      @11,3 ?? Txt[TblName]
      
    PICKDYNARRAYINDEX @1,4  HEIGHT 8  WIDTH 32  COLUMNS 2  Txt  TAG ""                        ; blank because tag is not used
    TO TblName
    
    PUSHBUTTON @14,7  WIDTH 10  "OK" OK DEFAULT  VALUE ""  TAG ""                        ;  tag name,
    TO Retval
    
    PUSHBUTTON @14,22  WIDTH 10  "Cancel" CANCEL  VALUE ""  TAG ""
    TO Retval

  ENDDIALOG
  RETURN IIF(Retval,TblName,False)
ENDPROC

PROC New_index()
;Create a new index table
  TblName=""
  TblDesc=""
  WHILE(TRUE)
  SHOWDIALOG "Create new Metric Index"
    @8,15 Height 9 Width 54
    @1,1 ?? "Index name:  "+TblName
      Accept @1,14 Width 11 "A8" Required Picture "*!"
      TAG "NewName" To TblName
    @3,1 ?? "Description: "+TblDesc
      Accept @3,14 Width 37 "A34" Required Picture "*@"
      TAG "NewDesc" to TblDesc
    Pushbutton @5,11 width 10 "OK" OK default value "" TAG ""
      to Retval
    Pushbutton @5,30 width 10 "Cancel" CANCEL value "" TAG ""
      to Retval
  ENDDIALOG
  if retval=false
  then clear return
  endif
  if tblname="" or tbldesc=""
  then message "Name and Description cannot be blank" loop
  endif
  if istable(tblname)
  then message tblname+" already exists - use a different name"
  loop
  endif
  errorproc="FileError"
  copy "m_index" tblname
  if istable(tblname)=false
  then message ErrorTxt beep
  release vars errorproc 
  loop
  endif
  view "m_table"
  editkey
  end down
  [table]=tblname
  [description]=tbldesc
  do_it! clear clearimage reset
  message tblname+" has been created"
  quitloop clear
  ENDWHILE
ENDPROC

PROC OutPut(Rept,R,Specs)
; select output device and prompt user for any needed action
private Specs,Rept,R,E,X,Y
  E = CHR(13)  ; Chr(13) is the [enter] key
  message "Select Output Device"
  ShowMenu
    "PRINTER": "Send output to the printer",
    "SCREEN" : "Send output to the screen",
    "FILE"   : "Send output to a file a drive a:",
    "CANCEL" : "Cancel output"
  To Y

  If Y = "Esc" or Y = "CANCEL"
    then return FALSE
  endif

  if Y = "SCREEN"
    then 
    message "Press [F2] to cancel and escape"
    {report} {output} select rept select r {screen}
    return
  endif

  if Y = "PRINTER"
    then clear
    if specs <> ""
      then
      message "Check printer settings and respond"
      ShowMenu
        "OK"  : "OK - Printer is set for: "+specs,
        "Esc" : "Escape to previous menu"
      To Y
      If Y = "Esc"
        then return
      endif
    endif
    clear
    while printerstatus() = false
      message "Printer is not ready" beep
      showmenu
        "Retry" : "Check printer and retry when ready",
        "Esc"   : "Cancel output and return to previous menu"
      to Y
      if Y = "Esc"
        then return
      endif
    endwhile
    {report} {output} select rept select r {printer}
    clear return
  endif

  if Y = "FILE"
    then clear
    @06,14 ?? "Press [Esc] to cancel output, or"
    @08,14 ?? "Enter the name of the output file [A:        .RPT]"
    @08,51 accept "a8" picture "&[&][&][&][&][&][&][&]" to RptName
    if retval = false or RptName = ""
      then return false
    endif
    while drivestatus("A") = false
      message "Drive A: is not ready" beep beep
      showmenu
        "Retry" : "Check diskette and/or drive A: and retry when ready",
        "Esc"   : "Cancel output and return to previous menu"
      to Y
      if Y = "Esc"
        then return
      endif
    endwhile
    if isfile("a:"+rptname+".rpt")
      then message "File A:"+rptname+".RPT already exists"
      clear
      showmenu
        "Cancel"  : "Cancel output, leave existing file intact",
        "Replace" : "Replace existing file with new output"
      to Y
      if Y = "Esc"
        then return
      endif
      if Y = "Cancel"
        then return
      endif
      if Y = "Replace"
        then {report} {output} select rept select r {file}
        select "a:"+rptname {replace}
        return
      endif
    return
    else {report} {output} select rept select r {file} select "a:"+rptname
    endif
  endif
ENDPROC

PROC FileError()
  ErrorTxt=Errormessage()
  Return 1
ENDPROC

M_INDEX()